/*
 * COPYRIGHT (c) 2010 by Institute of Computer Science, 
 * Foundation for Research and Technology - Hellas
 * Contact: 
 *      POBox 1385, Heraklio Crete, GR-700 13 GREECE
 *      Tel:+30-2810-391632
 *      Fax: +30-2810-391638
 *      E-mail: isl@ics.forth.gr
 *      http://www.ics.forth.gr/isl/cci.html
 * 
 *  This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 
 * Unported License (http://creativecommons.org/licenses/by-sa/3.0/)
*/

package Transformation;

/**
 * Public class
 * @author Koutraki Maria (kutraki@ics.forth.gr)
 */
public class CIDOCTriples {

    private SubjectClass Subject;
    private String Predicate;
    private ObjectClass Object;

    /**
     * Constructor of CIDOCTriples class.
     * @param subject, a SubjectClass object, subject of triple.
     * @param predicate, predicate of triple.
     * @param object, an ObjectClass object, object of triple.
     */
    public CIDOCTriples(SubjectClass subject, String predicate, ObjectClass object) {
        this.Subject = subject;
        this.Predicate = predicate;
        this.Object = object;
    }
    /**
     *  Return the subject of triple.
     * @return SubjectClass object.
     */
    public SubjectClass getSubject() {
        return Subject;
    }

    /**
     * Return the predicate of triple.
     * @return String predicate.
     */
    public String getPredicate() {
        return Predicate;
    }

    /**
     * Return the object of triple.
     * @return ObjectClass object.
     */
    public ObjectClass getObject() {
        return Object;
    }
}
